pathObj = $Dummy01
fishObj = $Fish1/FishBody
fishTail = $Fish1/FishBody/FishTail
relPos = [0,-150,-50] -- How close the fish is to the path

fishTail.bend.axis = 0 		-- 0 is the x-axis
zadd = 4					-- vertical movement at each step
tailFlapOffset = (random 0 100)
tailFlapRate = 25 + (random 0 25)

animate on
(
  for t = 1 to 100 do at time t
  (
    fishObj.position = pathObj.position + relPos
	fishObj.position.z = relPos.z
	relPos.z += zadd
	
	-- let's say that there's a 10% chance that the fish will
	-- change directions vertically
	if ((random 1 100) > 90) then
	(
	  zadd = -zadd
	)
	
	fishTail.bend.angle = 50 * sin (t * tailFlapRate +
	                                  tailFlapOffset)
    
	oldRt = fishObj.rotation.z_rotation
	newRt = (in coordsys pathObj pathObj.rotation.z_rotation)
	
	if ((random 1 100) > 85) then
	(
	  fishObj.rotation.z_rotation += (newRt - oldRt) *
	                                     (random 0.5 1.5)
	)
  )
)